function NavStateRule()
{
	this.target = null;
	this.actions = null;
	this.combine = null;
	this.operator = null;
	this.conditions = null;
	this.events = null;
	
	this.setDefaultValues();
}
NavStateRule.prototype.loadFromXMLNode = NavStateRuleLoadFromXMLNode;
NavStateRule.prototype.setDefaultValues = NavStateRuleSetDefaultValues;
NavStateRule.prototype.toString = NavStateRuleToString;
NavStateRule.prototype.resolveReferences = NavStateRuleResolveReferences;
NavStateRule.prototype.registerEvent = RegisterEvent;
NavStateRule.prototype.evaluate = NavStateRuleEvaluate;
NavStateRule.prototype.clone = NavStateRuleClone;

function NavStateRuleClone()
{
	var retVal = new NavStateRule();

	retVal.target = this.target.id;
	retVal.actions = new Array();
	for (var i=0;i<this.actions.length;i++)
	{
		retVal.actions[i] = this.actions[i];
	}
	retVal.combine = this.combine;
	retVal.operator = this.operator;
	
	retVal.conditions = new Array();
	for (var i=0;i<this.conditions.length;i++)
	{
		retVal.conditions[i] = this.conditions[i].clone();
	}

	retVal.events = new EventsObject(DEFAULT_RULE_EVENTS);
	
	return retVal;
}

function NavStateRuleEvaluate(ref)
{
	var str = "";
	var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||"));
	
	str = ((this.operator==NAV_OPERATOR_NOT)?("(!"):(""));
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):(""));
	if (eval(str) == true)
	{
		for (var i=0;i<this.actions.length;i++)
		{
			switch (this.actions[i])
			{
				case NAV_STATE_ACTION_MARK_COMPLETED:this.target.setCompleted(true);break;
				case NAV_STATE_ACTION_MARK_NOT_COMPLETED:this.target.setCompleted(false);break;
				case NAV_STATE_ACTION_MARK_SATISFIED:this.target.setSatisfied(true);break;
				case NAV_STATE_ACTION_MARK_NOT_SATISFIED:this.target.setSatisfied(false);break;
				case NAV_STATE_ACTION_ENABLE:this.target.setEnabled(true);break;
				case NAV_STATE_ACTION_DISABLE:this.target.setEnabled(false);break;
				case NAV_STATE_ACTION_HIDE:this.target.setVisible(false);break;
				case NAV_STATE_ACTION_SHOW:this.target.setVisible(true);break;
				case NAV_STATE_ACTION_SKIP:this.target.setSkip(true);break;
				case NAV_STATE_ACTION_DONT_SKIP:this.target.setSkip(false);break;
				case NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS:this.target.setBlock(true);break;
				case NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS:this.target.setBlock(false);break;
				case NAV_STATE_ACTION_ALLOW_CHOICE:this.target.setChoice(true);break;
				case NAV_STATE_ACTION_DONT_ALLOW_CHOICE:this.target.setChoice(false);break;
				case NAV_STATE_ACTION_ALLOW_FLOW:this.target.setFlow(true);break;
				case NAV_STATE_ACTION_DONT_ALLOW_FLOW:this.target.setFlow(false);break;
				case NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY:this.target.setForwardOnly(true);break;
				case NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY:this.target.setForwardOnly(false);break;
			}
		}
	}
}

function NavStateRuleResolveReferences(navRef)
{	
	for (var i=0;i<this.conditions.length;i++)
	{
		this.conditions[i].resolveReferences(navRef);
		this.conditions[i].registerEvent("changed","evaluate",this,null,true);
	}
}

function NavStateRuleToString()
{
	var str = "";
	var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or"));
	var strAction = "";
	
	for (var i=0;i<this.actions.length;i++)
	{
		switch (this.actions[i])
		{
			case NAV_STATE_ACTION_MARK_COMPLETED:strAction+="mark completed and ";break;
			case NAV_STATE_ACTION_MARK_NOT_COMPLETED:strAction+="mark not completed and ";break;
			case NAV_STATE_ACTION_MARK_SATISFIED:strAction+="mark satisfied and ";break;
			case NAV_STATE_ACTION_MARK_NOT_SATISFIED:strAction+="mark not satisfied and ";break;
			case NAV_STATE_ACTION_ENABLE:strAction+="enable and ";break;
			case NAV_STATE_ACTION_DISABLE:strAction+="disable and ";break;
			case NAV_STATE_ACTION_HIDE:strAction+="hide and ";break;
			case NAV_STATE_ACTION_SHOW:strAction+="show and ";break;
			case NAV_STATE_ACTION_SKIP:strAction+="skip and ";break;
			case NAV_STATE_ACTION_DONT_SKIP:strAction+="don't skip and ";break;
			case NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS:strAction+="block forward progress and ";break;
			case NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS:strAction+="allow forward progress and ";break;
			case NAV_STATE_ACTION_ALLOW_CHOICE:strAction+="allow choice navigation and ";break;
			case NAV_STATE_ACTION_DONT_ALLOW_CHOICE:strAction+="disable choice navigation and ";break;
			case NAV_STATE_ACTION_ALLOW_FLOW:strAction+="allow flow navigation and ";break;
			case NAV_STATE_ACTION_DONT_ALLOW_FLOW:strAction+="disable flow navigation and ";break;
			case NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY:strAction+="enable forward only navigation and ";break;
			case NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY:strAction+="disable forward only navigation and ";break;
		}
	}
	if (strAction.length > 0) strAction = strAction.slice(0,strAction.length-5);
	str = strAction + " if " + ((this.operator==NAV_OPERATOR_NOT)?("(not "):(""));
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):(""));
	return str;
}

function NavStateRuleSetDefaultValues()
{
	this.actions = new Array();
	this.combine = NAV_COMBINE_AND;
	this.operator = NAV_OPERATOR_NO_OP;
	this.conditions = new Array();
	this.events = new EventsObject(DEFAULT_RULE_EVENTS);
	this.target = null;
}

function NavStateRuleLoadFromXMLNode(xmlNode)
{
	this.setDefaultValues();
	
	var action = xmlNode.getAttribute("actions");
	if (action != null)
	{
		var actions = action.split(",");
		for (var i=0;i<actions.length;i++)
		{
			switch (actions[i].toLowerCase())
			{
				case "markcompleted":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_COMPLETED;break;
				case "marknotcompleted":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_NOT_COMPLETED;break;
				case "marksatisfied":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_SATISFIED;break;
				case "marknotsatisfied":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_NOT_SATISFIED;break;
				case "enable":this.actions[this.actions.length] = NAV_STATE_ACTION_ENABLE;break;
				case "disable":this.actions[this.actions.length] = NAV_STATE_ACTION_DISABLE;break;
				case "hide":this.actions[this.actions.length] = NAV_STATE_ACTION_HIDE;break;
				case "show":this.actions[this.actions.length] = NAV_STATE_ACTION_SHOW;break;
				case "skip":this.actions[this.actions.length] = NAV_STATE_ACTION_SKIP;break;
				case "donotskip":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_SKIP;break;
				case "blockforwardprogress":this.actions[this.actions.length] = NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS;break;
				case "allowforwardprogress":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS;break;
				case "enablechoice":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_CHOICE;break;
				case "disablechoice":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ALLOW_CHOICE;break;
				case "enableflow":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_FLOW;break;
				case "disableflow":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ALLOW_FLOW;break;
				case "enableforwardonly":this.actions[this.actions.length] = NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY;break;
				case "disableforwardonly":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY;break;
			}
		}
	}

	var operator = xmlNode.getAttribute("operator");
	switch ((operator+"").toLowerCase())
	{
		case "not":this.operator = NAV_OPERATOR_NOT;break;
		case "noop":this.operator = NAV_OPERATOR_NO_OP;break;
		default:this.operator = NAV_OPERATOR_NO_OP;break;
	}
	
	var combine = xmlNode.getAttribute("combine");
	switch ((combine+"").toLowerCase())
	{
		case "and":this.combine = NAV_COMBINE_AND;break;
		case "or":this.combine = NAV_COMBINE_OR;break;
		default:this.combine = NAV_COMBINE_AND;break;
	}

	for (var i=0;i<xmlNode.children.length;i++)
	{
		if (xmlNode.children[i].nodeType == "ELEMENT")
		{
			var isAggregator;
			var objTemp;
			var nodeName = xmlNode.children[i].tagName.toLowerCase();
			
			if (nodeName == "condand" || nodeName == "condor")
			{
				objTemp = new NavRuleConditionAggregator();
			}
			else
			{
				objTemp = new NavRuleCondition();
			}
			objTemp.loadFromXMLNode(xmlNode.children[i]);
			this.conditions[this.conditions.length] = objTemp;
		}
	}
}
